/* 
    EDIT THIS CODE WITH MOLESKINE, DAMN YOU.  STOP USING EMACS ALREADY.

    Love and kisses,
    
        -- You
*/

#ifndef GPGME_CPP_HEADER
#define GPGME_CPP_HEADER

#include <gpgme.h>
#include <vector>
#include <list>
#include <string>
#include <map>
#include <exception>
#include <algorithm>
#include <iostream>

namespace gpgme
{
    using std::exception;
    using std::vector;
    using std::list;
    using std::map;
    using std::pair;
    using std::string;
    
    enum Protocol { OpenPGP, CMS };
    enum KeyringLocale { LOCAL, EXTERN };

    // errswitch: takes a GpgmeError code and either throws an appropriate
    // exception (defined below) or else breaks out and returns.
    void errswitch(GpgmeError err);

    // A very generic exception class.  Everything else builds off it.  All
    // GPGME error states are wrapped in their own exception handlers, which
    // should make error-trapping pleasant.
    class GPGMEerr : public exception
    {
    private:
        string errstring;
    public:
        GPGMEerr(const char *what = "Unspecified") : errstring(what) {}
        ~GPGMEerr() throw() {}
        const char *what() const throw() { return errstring.c_str(); }
    };  

    class EndOfFile : public GPGMEerr
    {
    public:
        EndOfFile() : GPGMEerr("EOF") {}
    };
  
    class NoError : public GPGMEerr
    {
    public:
        NoError() : GPGMEerr("no error") {}
    };

    class GeneralError : public GPGMEerr
    {
    public:
        GeneralError() : GPGMEerr("general error") {}
    };
  
    class OutOfCore : public GPGMEerr
    {
    public:
        OutOfCore() : GPGMEerr("out of core") {}
    };
  
    class InvalidValue : public GPGMEerr
    {
    public:
        InvalidValue() : GPGMEerr("invalid value") {}
    };
  
    class Busy : public GPGMEerr
    {
    public:
        Busy() : GPGMEerr("busy") {}
    };
  
    class NoRequest : public GPGMEerr
    {
    public:
        NoRequest() : GPGMEerr("no request") {}
    };

      class ExecError : public GPGMEerr
    {
    public:
        ExecError() : GPGMEerr("exec error") {}
    };

    class TooManyProcs : public GPGMEerr
    {
    public:
        TooManyProcs() : GPGMEerr("too many procs") {}
    };

    class PipeError : public GPGMEerr
    {
    public:
        PipeError() : GPGMEerr("pipe error") {}
    };

    class NoRecipients : public GPGMEerr
    {
    public:
        NoRecipients() : GPGMEerr("no recipients") {}
    };

    class InvalidRecipients : public GPGMEerr
    {
    public:     
        InvalidRecipients() : GPGMEerr("invalid recipients") {}
    };

    class NoData : public GPGMEerr
    {
    public:
        NoData() : GPGMEerr("no data") {}
    };

    class Conflict : public GPGMEerr
    {
    public:
        Conflict() : GPGMEerr("conflict") {}
    };

    class NotImplemented : public GPGMEerr
    {
    public:
        NotImplemented() : GPGMEerr("not implemented") {}
    };

    class ReadError : public GPGMEerr
    {
    public:
        ReadError() : GPGMEerr("read error") {}
    };

    class WriteError : public GPGMEerr
    {
    public:
        WriteError() : GPGMEerr("write error") {}
    };

    class InvalidType : public GPGMEerr
    {
    public:
        InvalidType() : GPGMEerr("invalid type") {}
    };

    class InvalidMode : public GPGMEerr
    {
    public:
        InvalidMode() : GPGMEerr("invalid mode") {}
    };

    class FileError : public GPGMEerr
    {
    public:
        FileError() : GPGMEerr("file error") {}
    };

    class DecryptionFailed : public GPGMEerr
    {
    public:
        DecryptionFailed() : GPGMEerr("decryption failed") {}
    };

    class NoPassphrase : public GPGMEerr
    {
    public:
        NoPassphrase() : GPGMEerr("no passphrase") {}
    };

    class Canceled : public GPGMEerr
    {
    public:
        Canceled() : GPGMEerr("canceled") {}
    };

    class InvalidKey : public GPGMEerr
    {
    public:
        InvalidKey() : GPGMEerr("invalid key") {}
    };

    class InvalidEngine : public GPGMEerr
    {
    public:
        InvalidEngine() : GPGMEerr("invalid engine") {}
    };




    // There should be no need for an end user to instantiate this
    // class.  It is the common base class for everything else, but
    // it doesn't expose much functionality by itself.  Warning: this
    // class gets instantiated _a lot_.  Please keep the associated data
    // as lightweight as you can--the less initialization foo we have to
    // do, the faster contexts can be thrown together.
    
    // Please note: the copy assignment operator will give one Context
    // *the same* GpgmeCtx as another.  This presents problems when they
    // both go out of scope.  The first one will destruct properly and
    // the second one will segfault.  Thus, we have a boolean,
    // ctxNeedsFreeing, that tells us whether or not we need to handle
    // our context.  It's a kludge, but it works.
    class Context
    {
    public:
                        Context         (Protocol proto = OpenPGP);
                        Context         (const Context& original);
        Context&        operator=       (const Context& original);
        virtual         ~Context();
        void            setProtocol     (Protocol proto = OpenPGP);
        const bool      getArmor()                      const throw();
        void            setArmor(bool armor = true)     throw();
        const bool      getTextmode()                   const throw();
        void            setTextmode(bool which = false) throw();
        const int       getIncludeCerts()               const throw();
        void            setIncludeCerts(int certs)      throw();
        const KeyringLocale getKeylistMode()            const;
        void            setKeylistMode(KeyringLocale locale = LOCAL) 
                                                        throw();
        void            setPassphraseCallback           
            (GpgmePassphraseCb passfunc, void* hook)    throw()
            { gpgme_set_passphrase_cb(_ctx, passfunc, hook); }
        GpgmeCtx        getGpgmeCtx()                   const throw()
            { return _ctx; }

    protected:
        Protocol 
            _currentProto;
        
        KeyringLocale 
            _currentKeyringLocale;
        
        GpgmeCtx 
            _ctx;
        
    private:
        bool 
            _ctxNeedsFreeing;
    };
    
    
    
    
    
    namespace keys
    {
        enum KeyType { DSA };
        enum SubkeyType { ELG_E };

        class UID
        {
        public:
            UID(GpgmeKey key, unsigned long index);
                                    
            const unsigned long id()            const throw();
            const string&       name()          const throw();
            const string&       email()         const throw();
            const string&       comment()       const throw();
            const string&       validity()      const throw();
            const bool          revoked()       const throw();
            const bool          invalid()       const throw();
            const bool          valid()         const throw();
                
        private:
            unsigned long 
                _id, 
                _index;
            
            string 
                _name, 
                _email, 
                _comment, 
                _validity;
                
            bool 
                _revoked, 
                _invalid;
        };
        
        
        
        
        
        // Comparison functions are defined and operate off the key ID.
        // Other functions include key deletion, representation as XML
        // strings, and so forth.  Hopefully, soon we'll have a full
        // GPGME key implementation in this class.
        //
        // Please note the heavy use of const return types and const
        // method declarations.  It may be unnecessary, but it allows
        // the compiler to optimize more efficiently.
        //
        // The various member-accessors (id(), fingerprint(), etc.)
        // return const references to strings in the interest of
        // snappiness; returning a four-byte memory location's a lot
        // faster than constructing a string and returning it.
        
        class Key
        {
        public:
            typedef vector<UID>::iterator iterator;
            typedef vector<UID>::const_iterator const_iterator;
        
                    bool operator< (const Key &right)    const throw();
                    bool operator< (const string &right) const throw();
                    bool operator< (const char* right)   const throw();
                    bool operator==(const Key &right)    const throw();
                    bool operator==(const string &right) const throw();
                    bool operator==(const char* right)   const throw();
                    bool operator> (const Key &right)    const throw();
                    bool operator> (const string &right) const throw();
                    bool operator> (const char* right)   const throw();        
        
            explicit                    Key();
                                        Key(GpgmeKey keydata);
                                        Key(const Key &data);
                        Key&            operator=(const Key &data);
                                        ~Key();
                        string          getAsXML()      const throw();
                        GpgmeKey        getGpgmeKey()   const throw();
            const       string&         id()            const throw();
            const       string&         fingerprint()   const throw();
            const       string&         algo()          const throw();
            const       string&         name()          const throw();
            const       string&         email()         const throw();
            const       string&         comment()       const throw();
            const       string&         validity()      const throw();
            const       string&         capabilities()  const throw();
            const unsigned long         created()       const throw();
            const unsigned long         expires()       const throw();
            const       bool            isSecret()      const throw();
            const       bool            keyRevoked()    const throw();
            const       bool            keyInvalid()    const throw();
            const       bool            keyExpired()    const throw();
            const       bool            keyDisabled()   const throw();
            const       unsigned long   length()        const throw();
            const       unsigned long   userid()        const throw();
            const       bool            useridRevoked() const throw();
            const       bool            useridInvalid() const throw();
            const vector<UID>&          uids()          const throw();
                const_iterator          begin()         const throw();
                const_iterator          end()           const throw();
                        
        private:
            vector<UID> 
                _uids;
                
            string 
                _id, 
                _fingerprint, 
                _algo, 
                _name, 
                _email, 
                _comment, 
                _validity, 
                _capabilities;
                
            unsigned long 
                _created, 
                _expires, 
                _length, 
                _userid;
                
            bool 
                _isSecret, 
                _keyRevoked, 
                _keyInvalid, 
                _keyExpired,
                _keyDisabled, 
                _useridRevoked, 
                _useridInvalid;
      
            GpgmeKey 
                _key;
        };    
        
        
        // The KeyDB class is a representation of all the keys on the
        // user's keyring.  It offers an STL-like interface.
        //
        // Be careful constructing these objects.  They are computationally
        // expensive--not only does it have to iterate over the GPG keyring,
        // but it stores them internally ordered by key ID.  With a large
        // keyring (1000 keys), not only are you facing N disk I/O operations
        // to grab the keys, but you're facing NlogN in-memory operations
        // (complete with constructor cost) to sort the keys!
        //
        // On the other hand, you can find a key in a maximum of logN 
        // operations, so that's handy.  The guiding principle here is that
        // KeyDBs will not be constructed willy-nilly and will be used 
        // heavily.  Thus, an expensive start-up is acceptable if it means
        // much better performance over the lifetime of the object.
        
        class KeyDB : public Context
        {
        private:
            map<string, Key> 
                _keyring;
            
            bool 
                _privateonly;
            
        public:
            typedef map<string, Key>::iterator iterator;
            typedef map<string, Key>::const_iterator const_iterator;

                                        KeyDB
                (KeyringLocale where = LOCAL, 
                bool privatekeysonly = false);
                
                                        ~KeyDB();
            virtual void                update();
                    void                generateKey
                (KeyType kt, 
                unsigned int klen,
                SubkeyType skt, 
                unsigned int sklen, 
                string name,
                string email, 
                string comment, 
                string passphrase);
                
                    unsigned long       size()          const throw();
            const   Key&                operator[](const string& index);
                    const_iterator      begin()         const throw();
                    const_iterator      end()           const throw();
        };
        
        // A convenience class
        class PubKeyDB : public KeyDB
        {
        public:
            PubKeyDB(KeyringLocale where = LOCAL)
                : KeyDB(where, false) { }
        };
        
        // Likewise
        class PrivKeyDB : public KeyDB
        {
        public:
            PrivKeyDB(KeyringLocale where = LOCAL)
                : KeyDB(where, true) { }
        };
    }
    
    
    
    namespace util
    {
        using gpgme::keys::Key;
            
        class Recipients
        {
            private:
                list<Key> 
                    _recips;
                
            public:
                typedef list<Key>::iterator iterator;
                typedef list<Key>::const_iterator const_iterator;
                
                Recipients() 
                    { _recips.clear(); }
                Recipients(const Key &key) 
                    { _recips.clear(); _recips.push_back(key); }
                ~Recipients()
                    { _recips.clear(); }
                void clear() throw()
                    { _recips.clear(); }
                void push_back(const Key &key)
                    { _recips.push_back(key); }
                template <class Iter>
                void push_back(Iter first, Iter last)
                    { while (first != last) push_back(*iter++); }
                iterator begin() throw()
                    { return _recips.begin(); }
                const_iterator begin() const throw()
                    { return _recips.begin(); }
                iterator end() throw()
                    { return _recips.end(); }
                const_iterator end() const throw()
                    { return _recips.end(); }
                unsigned long size() const throw()
                    { return (unsigned long)_recips.size(); }
                GpgmeRecipients makeGpgmeRecipients() const;
        };
        
        class Data
        {
            private:
                vector<char> _data;
            public:
                typedef vector<char>::iterator iterator;
                typedef vector<char>::const_iterator const_iterator;
                
                void push_back(const char &data)
                    { _data.push_back(data); }
                template<class Iter>
                void push_back(Iter begin, Iter end)
                    { while (begin != end) push_back(*begin++); }                              
                iterator begin() throw()
                    { return _data.begin(); }
                const_iterator begin() const throw() 
                    { return _data.begin(); }
                iterator end() throw()
                    { return _data.end(); }
                const_iterator end() const throw()
                    { return _data.end(); }
                unsigned long size()
                    { return (unsigned long)_data.size(); }
                void clear()
                    {
                        iterator first = begin();                       
                        while (first != end()) *first++=static_cast<char>(0);
                        _data.clear();
                    }
                GpgmeData makeGpgmeData() const;
                
                Data(GpgmeData data)
                    {
                        size_t n;
                        char *first = gpgme_data_release_and_get_mem
                            (data, &n);
                        push_back(first, first + n);
                    }
                Data() 
                    { _data.clear() ; _data.reserve(65536); }
                template<class Iter>
                Data(Iter begin, Iter end)
                    {
                        _data.clear(); _data.reserve(65536);
                        push_back(begin, end);
                    }                    
                ~Data() 
                    { _data.clear(); }
        };
    }            
                    

    class Engine : public Context
        {
            protected:
                GpgmePassphraseCb _callback;
                util::Recipients _recip;
                list<keys::Key> _signers;                
                
                void updateSigners();
                
            public:
                Engine(GpgmePassphraseCb cb = NULL,
                    void *hook = NULL, Protocol proto = OpenPGP,
                    bool ASCIIarmor = true, bool textmode = false)
                        : Context(proto)
                    {
                        setPassphraseCallback(cb, hook);
                        setArmor(ASCIIarmor);
                        setTextmode(textmode);
                    }
                
                void addRecipient(const keys::Key &key)
                    { _recip.push_back(key); }
                void clearRecipients()
                    { _recip.clear(); }
                void setRecipients(const util::Recipients recip)
                    { _recip = recip; }
                void clearSigners()
                    { gpgme_signers_clear(_ctx); _signers.clear(); }
                void addSigner(keys::Key &key)
                    { _signers.push_back(key); }
                template <class Iter>
                void addSigner(Iter first, Iter last)
                    { while (first != last) _signers.push_back(*first++); }
                list<keys::Key>& getSignerList()
                    { return _signers; }
                    
                // All these are defined to work on either Data buffers or
                // generic sequences.  Yay, genericity.
                
                util::Data encrypt(const util::Data &plaintext);

                template<class Iter>
                util::Data encrypt(Iter begin, Iter end)
                    { util::Data foo(begin, end) ; return encrypt(foo); }
                
                // =====
                
                util::Data decrypt(const util::Data &ciphertext);
                
                template<class Iter>
                util::Data decrypt(Iter begin, Iter end)
                    { util::Data foo(begin, end) ; return decrypt(foo); }
                
                // =====
                
                GpgmeSigStat verify(const util::Data &signature,
                    const util::Data &data = NULL);
                
                template<class Iter>
                GpgmeSigStat verify(Iter begin_1, Iter end_1,
                    Iter begin_2 = NULL, Iter end_2 = NULL)
                    {
                        util::Data foo(begin_1, end_1);
                        if (begin_2 && end_2) 
                        {
                            util::Data bar(begin_2, end_2);
                            return verify(foo, bar);
                        }
                        return verify(foo);
                    }
                
                // =====
                
                pair<util::Data, GpgmeSigStat> decrypt_verify
                    (const util::Data &ciphertext);
                    
                template<class Iter>
                pair<util::Data, GpgmeSigStat> decrypt_verify
                    (Iter begin, Iter end)
                    { util::Data foo(begin, end) ; return decrypt_verify(foo); }
                
                // =====
                    
                util::Data encrypt_sign(const util::Data &plaintext);
                
                template<class Iter>
                util::Data encrypt_sign(Iter begin, Iter end)
                    { util::Data foo(begin, end) ; return encrypt_sign(foo); }
        };

    std::ostream& operator<<(std::ostream &os, util::Data &z);
}



#endif
